// Application.h
#ifndef _APP1_H
#define _APP1_H

//Includes
#include "../DXFramework/DXF.h"
#include "Skybox.h"
#include "TessellationPlane.h"
#include "TextureShader.h"
#include "ClipPlaneShader.h"
#include "WaterShader.h"
#include "TerrainTessellationShader.h"
#include "TerrainDepthShader.h"
#include "DepthShader.h"
#include "ShadowShader.h"
#include "BillboardGeometryShader.h"
#include "BillboardMesh.h"
#include "MotionBlurShader.h"
#include "GlowShader.h"
#include "GaussianBlurShader.h"
#include "BlendShader.h"

class App1 : public BaseApplication
{
	public:

		App1();
		~App1();
		void init(HINSTANCE hinstance, HWND hwnd, int screenWidth, int screenHeight, Input* in, bool VSYNC, bool FULL_SCREEN);

		bool frame();

	protected:
		bool render();
		void gui();

	private:
		//Info for spawning geometry - the type, mesh, texture and position data
		struct GeometryInfo
		{
			GeometryType type;
			BillboardMesh* mesh;
			ID3D11ShaderResourceView* texture;
			float xPosition;
			float yPosition;
			float zPosition;
		};

		//Shaders
		TextureShader* textureShader;
		ClipPlaneShader* clipPlaneShader;
		WaterShader* waterShader;
		TerrainTessellationShader* terrainTessellationShader;
		TerrainDepthShader* terrainDepthShader;
		DepthShader* depthShader;
		ShadowShader* shadowShader;
		BillboardGeometryShader* billboardGeometryShader;
		MotionBlurShader* motionBlurShader;
		GlowShader* glowShader;
		GaussianBlurShader* gaussianShader;
		BlendShader* blendShader;

		//Meshes, geometry and models
		Skybox* skybox;
		TessellationPlane* terrainPlane;
		PlaneMesh* waterPlane;
		CubeMesh* refractionWoodCube;
		AModel* hutModel;

		//Render textures for multiple passes and/or post-processing
		RenderTexture* reflectionRenderTexture;
		RenderTexture* refractionRenderTexture;
		RenderTexture* sceneRenderTexture;
		RenderTexture* glowTexture;
		RenderTexture* glowBlurTexture;
		RenderTexture* finalBloomTexture;
		RenderTexture* motionBlurTexture;

		//Ortho meshes for rendering render textures
		OrthoMesh* sceneOrtho;
		OrthoMesh* reflectionOrtho;
		OrthoMesh* refractionOrtho;
		OrthoMesh* shadowOrtho;

		//Initialize functions
		void InitializeShaders(HWND hwnd, int screenWidth, int screenHeight);
		void InitializeLighting();
		void SetLights();	//Called every frame to update lights

		void reflectionPass();	//Reflection - above the water
		void refractionPass();	//Refraction - below the water
		void depthPass();	//Depth - for shadowing/lighting
		void scenePass();	//Scene - main pass for rendering all the geometry
		void bloomPass();	//Bloom - Used to apply bloom
		void motionBlurPass();	//Motion Blur - Used to apply motion blur
		void finalPass();	//Final - Used to render the finalized texture to the display
		void renderToSceneOrtho(RenderTexture* texture);	//Renders the texture to the scene ortho mesh
	
		//Debug functions
		void DebugShowReflectRefract();
		void DebugShowShadowMap();

		XMMATRIX GetReflectionViewMatrix();
		XMMATRIX GetYAxisViewMatrix();

		//Water
		float waterRotation;

		//Used for determining motion blur values
		XMFLOAT3 previousCameraPosition;

		//Tessellation, lighting and post processing
		float minTessFactor;
		float maxTessFactor;
		bool motionBlurToggle;
		float motionBlurXFactor;
		float motionBlurYFactor;
		bool bloomToggle;
		float glowIntensities[3];

		//Lighting and shadowing
		Light* sunLight;
		float sunLightPosition[3], sunLightDiffuse[3], sunLightAmbient[3], sunLightDirection[3];

		Light* spotLight;
		float spotLightPosition[3], spotLightDiffuse[3], spotLightDirection[3];
		float constantFactor; float linearFactor; float quadraticFactor;

		Light* hillPointLight;
		float hillPointLightPosition[3], hillPointLightDiffuse[3];

		ShadowMap* sunShadowMap;
		ShadowMap* spotShadowMap;
		ShadowMap* hillShadowMaps[6];
		float sobelScaleFactor;
		bool normalsToggle;

		//Billboarding
		void SetAlphaToCoverageEnabled(bool enabled);	
		void GetGeometryPositions();
		std::vector<GeometryInfo> geometryMeshes;
};

#endif